import type { Schema } from "../resource"
// @ts-ignore
import { env } from "$amplify/env/invite-user"
import {
  CognitoIdentityProviderClient,
  AdminCreateUserCommand,
  AdminAddUserToGroupCommand,
} from "@aws-sdk/client-cognito-identity-provider"
import { DynamoDBClient } from "@aws-sdk/client-dynamodb";
import {
  DynamoDBDocumentClient,
  PutCommand
} from "@aws-sdk/lib-dynamodb";
import { getUserIdFromAttributes } from "../../lib/user";

const INTERNAL__fallbackCognitoGroupName = "VIEWER" as const

type Handler = Schema["inviteNewUser"]["functionHandler"]
const client = new CognitoIdentityProviderClient()

type INTERNAL__UserMetadataStructure = Schema["UsersMetadata"]["createType"]

const dynamoClient = new DynamoDBClient({});

const dynamo = DynamoDBDocumentClient.from(dynamoClient);

export const handler: Handler = async (event) => {
  const { email, groupName, agencyid } = event.arguments
  const groupNameToAdd = groupName ?? env.BACKEND_DEFAULT_COGNITO_GROUP_NAME ?? INTERNAL__fallbackCognitoGroupName

  const userPoolId = getUserpoolFromLambdaEnvironment(env)
  const createCommand = new AdminCreateUserCommand({
    Username: email,
    UserPoolId: userPoolId,
  })

  const response = await client.send(createCommand)
  if (!response.User) {
    return response
  }

  const addToGroupCommand = new AdminAddUserToGroupCommand({
    Username: email,
    GroupName: groupNameToAdd,
    UserPoolId: userPoolId,
  })

  const _ = await client.send(addToGroupCommand)

  try {
    const id = getUserIdFromAttributes(response.User.Attributes)
    if (!id) {
      return {
        statusCode: 404,
        error: JSON.stringify({
          message: `Unable to find expected user id for newly created user '${email}'`,
          $metadata: response.User
        })
      }
    }
    const dynamoPutCommandResults = await dynamo.send(
      new PutCommand({
        TableName: env.BACKEND_USER_METADATA_DYNAMODB_TABLENAME,

        Item: {
          agencyid: agencyid,
          userid: id,
        } satisfies INTERNAL__UserMetadataStructure
      })
    )

    console.log('InviteNewUser - DynamoPutCommand\n', dynamoPutCommandResults.$metadata, '\n', dynamoPutCommandResults.Attributes, '\n', dynamoPutCommandResults.ItemCollectionMetrics)

    return response
  } catch (e) {
    return {
      statusCode: 500,
      error: e,
    }
  }
}

function INTERNAL__generateEnvironmentUserpoolKey() {
  return `${env.BACKEND_AWS_COGNITO_RESOURCE_NAME_PREFIX.toUpperCase()}_USERPOOL_ID`
}

export function getUserpoolFromLambdaEnvironment(lambdaEnvironment: Record<string, string>) {
  const key = INTERNAL__generateEnvironmentUserpoolKey()
  return lambdaEnvironment[key]
}
